###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for login(1) HPSBUX00160
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835106);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00160");
  script_cve_id("");
  script_name( "HP-UX Update for login(1) HPSBUX00160");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  login(1). The vulnerability could be exploitedlocally to gain increased 
  privilege. 

  Impact:
  Local increased privilege.

  Affected Software/OS:
  login(1) on
  HP-UX release B.10.20, B.10.24, B.10.26, B.11.00, B.11.04, and B.11.11. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00994275-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of login(1)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHCO_24083'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.24")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHNE_24394'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE-ENG-A-MAN", patch_list:['PHNE_24394'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VirtualVaultOS.VVOS-AUX-IA", patch_list:['PHNE_24394'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-INETD", patch_list:['PHNE_24394'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INET-ENG-A-MAN", patch_list:['PHNE_24394'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_24394'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.26")
{

  if(ishpuxpkgvuln(pkg:"BLS.BLS-CORE", patch_list:['PHCO_24454'], rls:"HPUX10.26"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHCO_24418'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.20")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHCO_24267'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHCO_23900'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}