###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_horde_imp_info_disc_vuln.nasl 7066 2010-02-03 12:33:29 feb $
#
# Horde IMP Information Disclosure Vulnerability
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800288);
  script_version("$Revision$: 1.0");
  script_cve_id("CVE-2010-0463");
  script_name("Horde IMP Information Disclosure Vulnerability");
  desc = "
  Overview: This host is running Horde IMP and is prone to Information Disclosure
  vulnerability

  Vulnerability Insight:
  The flaw exists when DNS prefetching of domain names contained in links within
  e-mail messages.

  Impact:
  Successful exploitation allows remote attackers to determine the network location
  of the webmail user by logging DNS requests.

  Impact Level: Application.

  Affected Software/OS:
  Horde IMP version 4.3.6 and prior.

  Fix:
  No solution or patch is available as on 03rd, February 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.horde.org/download/

  References:
  http://bugs.horde.org/ticket/8836
  http://www.security-database.com/detail.php?alert=CVE-2010-0463
  https://secure.grepular.com/DNS_Prefetch_Exposure_on_Thunderbird_and_Webmail

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 4.2
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Horde IMP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_dependencies("horde_detect.nasl");
  script_family("General");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

hordePort = get_http_port(default:80);
if(!hordePort){
  exit(0);
}

hordeVer = get_kb_item("www/" + hordePort + "/horde");
if(!hordeVer){
  exit(0);
}

foreach dir (make_list("/horde/imp", "/Horde/IMP", cgi_dirs()))
{
  sndReq = http_get(item:string(dir , "/test.php"), port:hordePort );
  rcvRes = http_keepalive_send_recv(port:hordePort, data:sndReq);

  if("imp" >< rcvRes || "IMP" >< rcvRes)
  {
    impVer = eregmatch(pattern:"IMP: H3 .([0-9.]+)" , string:rcvRes);
    if(impVer[1] != NULL)
    {
      if(version_is_less_equal(version:impVer[1], test_version:"4.3.6"))
      {
        security_warning(hordePort);
        exit(0);
      }
    }
  }
}
