###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_grabit_detect_win.nasl 2207 2009-05-18 13:30:24Z may $
#
# Grabit Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http//intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800712);
  script_version("$Revision: 1.0 $");
  script_name("Grabit Version Detection");
  desc = "

  Overview : This script finds the installed Grabit Version in Windows and
  saves the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set Version of Grabit in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\GrabIt_is1\";
name = registry_get_sz(key:key, item:"DisplayName");

if("GrabIt" >< name)
{
  grabitVer = eregmatch(pattern:"GrabIt ([0-9.]+) Beta\ ?([0-9]+)?", string:name);
  build = eregmatch(pattern:"build ([0-9]+)", string:name);

  if(grabitVer[1] != NULL && grabitVer[2] == NULL){
    appVer = grabitVer[1];
  }
  else if(grabitVer[1] != NULL && grabitVer[2] != NULL)
  {
    # Beta version string goes here in the 2nd index value.
    appVer = grabitVer[1] + "." + grabitVer[2];
  }

  set_kb_item(name:"GrabIt/Ver", value:appVer);

  if(build[1] != NULL){
    set_kb_item(name:"GrabIt/Build/Ver", value:build[1]); # Sets for Build Version.
  }
}
