###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_grabit_bof_vuln.nasl 2207 2009-05-18 14:45:29Z may $
#
# GrabIt Stack Based Buffer Overflow Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800713);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1586");
  script_bugtraq_id(34807);
  script_name("GrabIt Stack Based Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with GrabIt and is prone to stack-based
  buffer overflow vulnerability.

  Vulnerability Insight:
  This flaw is due to a boundary check error when processing the DOCTYPE
  declaration within '.NZB' files.

  Impact:
  Successful exploitation will let the attacker cause stack overflow by
  crafting an 'NZB' file containing an overly large string as DTD URI.

  Impact level: Application

  Affected Software/OS:
  GrabIt version 1.7.2 Beta 3 and prior.

  Fix:
  Upgrade to the latest version 1.7.2 Beta 4
  http://www.shemes.com/index.php?p=download

  References:
  http://secunia.com/advisories/34893
  http://www.milw0rm.com/exploits/8612
  http://www.shemes.com/index.php?p=whatsnew

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of GrabIt");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_grabit_detect.nasl");
  script_require_keys("GrabIt/Ver");
  exit(0);
}


include("version_func.inc");

grabitVer = get_kb_item("GrabIt/Ver");
if(grabitVer == NULL){
  exit(0);
}

# Grep for GrabIt version 1.7.2 Beta 3 or prior.
if(version_is_less(version:grabitVer, test_version:"1.7.2.4")){
  security_hole(0);
}
