###############################################################################
# OpenVAS Vulnerability Test
# $Id:gb_google_chrome_clickjacking_vuln.nasl 931 2009-02-04 10:00:29Z feb $
#
# Google Chrome Clickjacking Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800223);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0374");
  script_name("Google Chrome Clickjacking Vulnerability");
  desc = "

  Overview: This host is installed with Google Chrome and is prone to
  clickjacking vulnerability.

  Vulnerability Insight:
  Clickjacking attack vector which hides the destination authentic URL and
  places arbitrary malicious URL which is being displayed in the user's
  browser.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in
  the context of the web browser and can gain sensitive information of the
  remote user through the crafted URL through arbitrary scripts.

  Affected Software/OS:
  Google Chrome version 1.0.154.43 and prior.

  Fix: No solution or patch is available as on 04th February 2009, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://googlechromereleases.blogspot.com

  References:
  http://www.milw0rm.com/exploits/7903
  http://www.securityfocus.com/archive/1/archive/1/500533/100/0/threaded
  http://www.securityfocus.com/archive/1/archive/1/500499/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

# Grep for Chrome version 1.0.154.43
if(version_is_less_equal(version:chromeVer, test_version:"1.0.154.43")){
  security_warning(0);
}
