##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_gnutls_detect_win.nasl 3739 2009-08-04 18:30:24Z aug $
#
# GnuTLS Version Detection (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800916);
  script_version("$Revision: 1.0 $");
  script_name("GnuTLS Version Detection (Win)");
  desc = "
  Overview : This script finds the installed GnuTLS version and saves the
  result in KB item.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set Version of GnuTLS in KB for Windows");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

foreach item (registry_enum_keys(key:"SOFTWARE\"))
{
  if("GnuTLS" >< item)
  {
    key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
    gnutlsVer = registry_get_sz(key:key + item, item:"DisplayVersion");

    if(gnutlsVer != NULL){
      set_kb_item(name:"GnuTLS/Win/Ver", value:gnutlsVer);
    }
  }
}
