###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_foswiki_csrf_vuln.nasl 2120 2009-05-09 17:16:17Z may $
#
# Foswiki Cross-Site Request Forgery Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800613);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1434");
  script_name("Foswiki Cross-Site Request Forgery Vulnerability");
  desc = "

  Overview:
  The host is running Foswiki and is prone to Cross-Site Request Forgery
  Vulnerability.

  Vulnerability Insight:
  An application allowing users to perform certain actions via HTTP requests
  without performing any validity checks to verify the requests.

  Impact:
  Successful exploitation will let the attacker to gain administrative
  privileges on the target application and can cause CSRF attack.

  Impact Level: Application

  Affected Software/OS:
  Foswiki version prior to 1.0.5

  Fix: Upgrade to version 1.0.5 or later,
  http://foswiki.org/Download

  References:
  http://secunia.com/advisories/34863
  http://foswiki.org/Support/SecurityAlert-CVE-2009-1434

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Foswiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_foswiki_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

foswikiPort = get_http_port(default:80);

if(!foswikiPort){
  exit(0);
}

foswikiVer = get_kb_item("www/" + foswikiPort + "/Foswiki");

if(foswikiVer != NULL)
{
  foswikiVer = eregmatch(pattern:"^(.+) under (/.*)$", string:foswikiVer);
  if(foswikiVer[1] != NULL)
  {
    if(version_is_less(version:foswikiVer[1], test_version:"1.0.5")){
      security_warning(foswikiPort);
    }
  }
}
