###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_flatchat_dir_trav_vuln.nasl 2100 2009-05-09 17:16:17Z may $
#
# Flatchat Directory Traversal Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800323);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1486");
  script_bugtraq_id(34734);
  script_name("Flatchat Directory Traversal Vulnerability");
  desc = "

  Overview: The host is running Flatchat and is prone to Directory Traversal
  vulnerability.

  Vulnerability Insight:
  Improper handling of user supplied input into the  pmscript.php file via
  ..(dot dot) in 'with' parameter, can lead to directory traversal.

  Impact:
  Successful attacks can cause inclusion or execution of arbitrary local files
  in the context of the webserver process via directory traversal attacks and
  URL-encoded NULL-bytes.

  Impact Level: Application

  Affected Software/OS:
  Flatchat version 3.0 and prior

  Fix: No solution or patch is available as on 18th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://ninjadesigns.co.uk/

  References:
  http://secunia.com/advisories/34904
  http://www.milw0rm.com/exploits/8549

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Flatchat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_flatchat_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

flatchatPort = get_http_port(default:80);
if(!flatchatPort){
  exit(0);
}

fcVer = get_kb_item("www/" + flatchatPort + "/Flatchat");
fcVer = eregmatch(pattern:"^(.+) under (/.*)$", string:fcVer);

if(fcVer[1] != NULL)
{
  if(version_is_less_equal(version:fcVer[1], test_version:"3.0")){
    security_hole(flatchatPort);
  }
}
