###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_xsl_parsing_vuln_lin.nasl 1267 2009-04-07 12:42:20Z apr $
#
# Firefox XSL Parsing Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800377);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1169");
  script_bugtraq_id(34235);
  script_name("Firefox XSL Parsing Vulnerability (Linux)");
  desc = "

  Overview: The host is installed with Mozilla Firefox browser and is prone
  to XSL File Parsing Vulnerability.

  Vulnerability Insight:
  This flaw is due to improper handling of errors encountered when transforming
  an XML document which can be exploited to cause memory corrpution through a
  specially crafted XSLT code.

  Impact:
  Successful exploitation will let the attacker cause remote code execution
  through a specially crafted malicious XSL file or can cause application
  termination at runtime.

  Impact Level: System/Application

  Affected Software/OS:
  Firefox version 3.0 to 3.0.7 on Linux.

  Fix: Upgrade to Firefox version 3.0.8
  http://www.mozilla.com/en-US/firefox/firefox.html

  References:
  http://secunia.com/advisories/34471
  http://www.milw0rm.com/exploits/8285
  http://securitytracker.com/alerts/2009/Mar/1021941.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-12.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer){
  exit(0);
}

# Grep for firefox version 3.0 to 3.0.7
if(version_in_range(version:ffVer, test_version:"3.0", test_version2:"3.0.7")){
  security_hole(0);
}
