###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_data_uri_xss_vuln_sep09_win.nasl 4411 2009-09-04 14:03:26Z sep $
#
# Mozilla Firefox 'data:' URI XSS Vulnerability - Sep09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800889);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3012");
  script_name("Mozilla Firefox 'data:' URI XSS Vulnerability - Sep09 (Win)");
  desc = "
  Overview: This host is installed with Mozilla Product(s) and is prone to
  Cross-Site Scripting vulnerability.

  Vulnerability Insight:
  Firefox fails to sanitise the 'data:' URIs in Location headers in HTTP
  responses, which can be exploited via vectors related to injecting a
  Location header or Location HTTP response header.

  Impact:
  Successful exploitation will let the attackers to conduct Cross-Site Scripting
  attacks in the victim's system.

  Impact Level: Application

  Affected Software/OS:
  Mozilla, Firefox version 3.0.13 and prior, 3.5 and 3.6/3.7 a1 pre on Windows.

  Fix: No solution or patch is available as on 04th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mozilla.org/

  References:
  http://websecurity.com.ua/3323/
  http://websecurity.com.ua/3386/

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the vulnerable version of Mozilla Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

# Firefox Check
ffVer = get_kb_item("Firefox/Win/Ver");

if(ffVer)
{
  # Grep for Firefox version <= 3.0.13 or 3.5 or 3.6 a1 pre or 3.7 a1 pre
  if(version_is_less_equal(version:ffVer, test_version:"3.0.13")||
     version_is_equal(version:ffVer, test_version:"3.5")){
    security_warning(0);
  }
}
else if(registry_key_exists(key:"SOFTWARE\Mozilla\Minefield"))
{
  foreach item (registry_enum_keys(key:"SOFTWARE\Mozilla\Minefield"))
  {
    ver = eregmatch(pattern:"([0-9.]+a1pre)", string:item);
    # Firefox 3.6a1pre or 3.7a1pre Version check
    if(ver[1] =~ "3\.[6|7]a1pre")
      security_warning(0);
  }
}
