###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_chrome_priv_esc_vuln_aug09_lin.nasl 3793 2009-08-05 21:20:33Z aug $
#
# Mozilla Firefox Chrome Privilege Escalation Vulnerability Aug-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800860);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2665");
  script_bugtraq_id(35928);
  script_name("Mozilla Firefox Chrome Privilege Escalation Vulnerability Aug-09 (Linux)");
  desc = "

  Overview: This host is installed with Mozilla Firefox and is prone to Chrome
  Privilege Escalation vulnerability.

  Vulnerability Insight:
  Error in 'nsDocument::SetScriptGlobalObject()' function in 'nsDocument.cpp' in
  content/base/src/ which does not properly handle a Link HTTP header, which
  allows remote attackers to execute arbitrary JavaScript with chrome
  privileges via a crafted web page, related to an incorrect security wrapper.

  Impact:
  Successful exploitation will let attacker to execute arbitrary JavaScript with
  chrome privileges when certain add-ons are enabled.

  Impact Level: Application

  Affected Software/OS:
  Firefox version 3.5 before 3.5.2 on Linux.

  Fix: Upgrade to Firefox version 3.5.2
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  https://bugzilla.mozilla.org/show_bug.cgi?id=498897
  http://www.mozilla.org/security/announce/2009/mfsa2009-46.html

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.3
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Privilege escalation");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer){
  exit(0);
}

# Grep for Firefox version 3.5 < 3.5.2
if(version_in_range(version:ffVer, test_version:"3.5",
                                  test_version2:"3.5.1")){
  security_warning(0);
}
