###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for sunbird FEDORA-2010-3230
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861747);
  script_version("$Revision: 6917 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-3230");
  script_cve_id("CVE-2010-0159", "CVE-2009-1571");
  script_name("Fedora Update for sunbird FEDORA-2010-3230");
  desc = "

  Vulnerability Insight:
  Mozilla Sunbird is a cross-platform calendar application, built upon
  Mozilla Toolkit. It brings Mozilla-style ease-of-use to your
  calendar, without tying you to a particular storage solution.


  Affected Software/OS:
  sunbird on Fedora 12

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-March/036098.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of sunbird");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC12")
{

  if(isrpmvuln(pkg:"sunbird", rpm:"sunbird~1.0~0.19.20090916hg.fc12", rls:"FC12"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}