###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for gnash FEDORA-2010-1833
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861690);
  script_version("$Revision: 6862 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-1833");
  script_cve_id("CVE-2009-3736");
  script_name("Fedora Update for gnash FEDORA-2010-1833");
  desc = "

  Vulnerability Insight:
  Gnash is capable of reading up to SWF v9 files and opcodes, but primarily
  supports SWF v7, with better SWF v8 and v9 support under heavy development.
  Gnash includes initial parser support for SWF v8 and v9. Not all
  ActionScript 2 classes are implemented yet, but all of the most heavily
  used ones are. Many ActionScript 2 classes are partially implemented;
  there is support for all of the commonly used methods of each
  class.


  Affected Software/OS:
  gnash on Fedora 11

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-February/035093.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gnash");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC11")
{

  if(isrpmvuln(pkg:"gnash", rpm:"gnash~0.8.6~13.fc11", rls:"FC11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}