###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for gif2png FEDORA-2010-0330
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861685);
  script_version("$Revision: 6862 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-0330");
  script_name("Fedora Update for gif2png FEDORA-2010-0330");
  desc = "

  Vulnerability Insight:
  The gif2png program converts files from the obsolescent Graphic Interchange
  Format to Portable Network Graphics. The conversion preserves all graphic
  information, including transparency, perfectly. The gif2png program can
  even recover data from corrupted GIFs.
  
  There exists a 'web2png' program in a separate package which is able
  to convert entire directory hierarchies.


  Affected Software/OS:
  gif2png on Fedora 11

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-January/033890.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gif2png");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC11")
{

  if(isrpmvuln(pkg:"gif2png", rpm:"gif2png~2.5.1~1102.fc11", rls:"FC11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}