###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for NetworkManager FEDORA-2009-13642
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861604);
  script_version("$Revision: 6414 $: 1.0");
  script_xref(name: "FEDORA", value: "2009-13642");
  script_cve_id("CVE-2009-4145", "CVE-2009-4144");
  script_name("Fedora Update for NetworkManager FEDORA-2009-13642");
  desc = "

  Vulnerability Insight:
  NetworkManager attempts to keep an active network connection available at all
  times.  It is intended only for the desktop use-case, and is not intended for
  usage on servers.   The point of NetworkManager is to make networking
  configuration and setup as painless and automatic as possible.  If using DHCP,
  NetworkManager is _intended_ to replace default routes, obtain IP addresses
  from a DHCP server, and change nameservers whenever it sees fit.


  Affected Software/OS:
  NetworkManager on Fedora 11

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2010-January/msg00122.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of NetworkManager");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC11")
{

  if(isrpmvuln(pkg:"NetworkManager", rpm:"NetworkManager~0.7.2~2.git20091223.fc11", rls:"FC11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}