###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for quassel FEDORA-2008-9658
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860156);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-9658");
  script_cve_id("");
  script_name( "Fedora Update for quassel FEDORA-2008-9658");
  desc = "

  Vulnerability Insight:
  Quassel IRC is a modern, distributed IRC client,
  meaning that one (or multiple) client(s) can attach
  to and detach from a central core --
  much like the popular combination of screen and a
  text-based IRC client such as WeeChat, but graphical


  Affected Software/OS:
  quassel on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-November/msg00354.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of quassel");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"quassel", rpm:"quassel~0.3.0.3~1.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}