###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for pam_mount FEDORA-2008-7973
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860191);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-7973");
  script_cve_id("");
  script_name( "Fedora Update for pam_mount FEDORA-2008-7973");
  desc = "

  Vulnerability Insight:
  This module is aimed at environments with central file servers that a
  user wishes to mount on login and unmount on logout, such as
  (semi-)diskless stations where many users can logon.
  
  The module also supports mounting local filesystems of any kind the
  normal mount utility supports, with extra code to make sure certain
  volumes are set up properly because often they need more than just a
  mount call, such as encrypted volumes. This includes SMB/CIFS, NCP,
  davfs2, FUSE, losetup crypto, dm-crypt/cryptsetup and truecrypt.
  
  If you intend to use pam_mount to protect volumes on your computer
  using an encrypted filesystem system, please know that there are many
  other issues you need to consider in order to protect your data.  For
  example, you probably want to disable or encrypt your swap partition.
  Don't assume a system is secure without carefully considering
  potential threats.


  Affected Software/OS:
  pam_mount on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-September/msg00730.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of pam_mount");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"pam_mount", rpm:"pam_mount~0.47~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}