###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for fedora-ds-base FEDORA-2008-7813
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860828);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-7813");
  script_cve_id("CVE-2008-2930", "CVE-2008-3283");
  script_name( "Fedora Update for fedora-ds-base FEDORA-2008-7813");
  desc = "

  Vulnerability Insight:
  Fedora Directory Server is an LDAPv3 compliant server.  The base package includes
  the LDAP server and command line utilities for server administration.


  Affected Software/OS:
  fedora-ds-base on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-September/msg00521.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of fedora-ds-base");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"fedora-ds-base", rpm:"fedora-ds-base~1.1.2~1.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}