###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for awstats FEDORA-2008-7663
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860678);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-7663");
  script_cve_id("CVE-2008-3714");
  script_name( "Fedora Update for awstats FEDORA-2008-7663");
  desc = "

  Vulnerability Insight:
  Advanced Web Statistics is a powerful and featureful tool that generates
  advanced web server graphic statistics. This server log analyzer works
  from command line or as a CGI and shows you all information your log contains,
  in graphical web pages. It can analyze a lot of web/wap/proxy servers like
  Apache, IIS, Weblogic, Webstar, Squid, ... but also mail or ftp servers.
  
  This program can measure visits, unique vistors, authenticated users, pages,
  domains/countries, OS busiest times, robot visits, type of files, search
  engines/keywords used, visits duration, HTTP errors and more...
  Statistics can be updated from a browser or your scheduler.
  The program also supports virtual servers, plugins and a lot of features.
  
  With the default configuration, the statistics are available:
  <a  rel= &qt nofollow &qt  href= &qt http://localhost/awstats/awstats.pl &qt >http://localhost/awstats/awstats.pl</a>


  Affected Software/OS:
  awstats on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-September/msg00107.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of awstats");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"awstats", rpm:"awstats~6.8~2.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}