###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for samba FEDORA-2008-7243
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860451);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-7243");
  script_cve_id("CVE-2008-3789", "CVE-2008-1105");
  script_name( "Fedora Update for samba FEDORA-2008-7243");
  desc = "

  Vulnerability Insight:
  Samba is the suite of programs by which a lot of PC-related machines
  share files, printers, and other information (such as lists of
  available files and printers). The Windows NT, OS/2, and Linux
  operating systems support this natively, and add-on packages can
  enable the same thing for DOS, Windows, VMS, UNIX of all kinds, MVS,
  and more. This package provides an SMB/CIFS server that can be used to
  provide network services to SMB/CIFS clients.
  Samba uses NetBIOS over TCP/IP (NetBT) protocols and does NOT
  need the NetBEUI (Microsoft Raw NetBIOS frame) protocol.


  Affected Software/OS:
  samba on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-September/msg00271.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of samba");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.2.3~0.20.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}