###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for trac FEDORA-2008-6830
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860203);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-6830");
  script_cve_id("CVE-2008-2951", "CVE-2008-3328");
  script_name( "Fedora Update for trac FEDORA-2008-6830");
  desc = "

  Vulnerability Insight:
  Trac is an integrated system for managing software projects, an
  enhanced wiki, a flexible web-based issue tracker, and an interface to
  the Subversion revision control system.  At the core of Trac lies an
  integrated wiki and issue/bug database. Using wiki markup, all objects
  managed by Trac can directly link to other issues/bug reports, code
  changesets, documentation and files.  Around the core lies other
  modules, providing additional features and tools to make software
  development more streamlined and effective.


  Affected Software/OS:
  trac on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-July/msg01261.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of trac");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"trac", rpm:"trac~0.10.5~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}