###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for jetty FEDORA-2008-6164
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860534);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-6164");
  script_cve_id("CVE-2007-5615", "CVE-2007-5614", "CVE-2007-5613");
  script_name( "Fedora Update for jetty FEDORA-2008-6164");
  desc = "

  Vulnerability Insight:
  Jetty is a 100% Java HTTP Server and Servlet Container.
  This means that you do not need to configure and run a
  separate web server (like Apache) in order to use java,
  servlets and JSPs to generate dynamic content. Jetty is
  a fully featured web server for static and dynamic content.
  Unlike separate server/container solutions, this means
  that your web server and web application run in the same
  process, without interconnection overheads and complications.
  Furthermore, as a pure java component, Jetty can be simply
  included in your application for demonstration, distribution
  or deployment. Jetty is available on all Java supported
  platforms.


  Affected Software/OS:
  jetty on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-July/msg00250.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of jetty");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"jetty", rpm:"jetty~5.1.14~1jpp.1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}