###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for cbrpager FEDORA-2008-4528
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860585);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-4528");
  script_cve_id("");
  script_name( "Fedora Update for cbrpager FEDORA-2008-4528");
  desc = "

  Vulnerability Insight:
  A no-nonsense, simple to use, small viewer for cbr and cbz
  (comic book archive) files. As it is written in C,
  the executable is small and fast. It views jpg (or jpeg),
  gif and png images, and you can zoom in and out.


  Affected Software/OS:
  cbrpager on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-May/msg00853.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of cbrpager");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"cbrpager", rpm:"cbrpager~0.9.17~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}