###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for blender FEDORA-2008-3862
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860708);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-3862");
  script_cve_id("CVE-2008-1102", "CVE-2008-1103");
  script_name( "Fedora Update for blender FEDORA-2008-3862");
  desc = "

  Vulnerability Insight:
  Blender is the essential software solution you need for 3D, from modeling,
  animation, rendering and post-production to interactive creation and playback.
  
  Professionals and novices can easily and inexpensively publish stand-alone,
  secure, multi-platform content to the web, CD-ROMs, and other media.
  
  This version doesn't contains ffmpeg support, so that any features may be not
  available.


  Affected Software/OS:
  blender on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-May/msg00225.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of blender");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"blender", rpm:"blender~2.45~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}