###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for lighttpd FEDORA-2008-3376
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860849);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-3376");
  script_cve_id("CVE-2008-0983", "CVE-2008-1111", "CVE-2008-1531");
  script_name( "Fedora Update for lighttpd FEDORA-2008-3376");
  desc = "

  Vulnerability Insight:
  Secure, fast, compliant and very flexible web-server which has been optimized
  for high-performance environments. It has a very low memory footprint compared
  to other webservers and takes care of cpu-load. Its advanced feature-set
  (FastCGI, CGI, Auth, Output-Compression, URL-Rewriting and many more) make
  it the perfect webserver-software for every server that is suffering load
  problems.
  
  Available rpmbuild rebuild options :
  --with : gamin webdavprops webdavlocks memcache
  --without : ldap gdbm lua (cml)


  Affected Software/OS:
  lighttpd on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-April/msg00587.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of lighttpd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"lighttpd", rpm:"lighttpd~1.4.19~4.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}