###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for epiphany FEDORA-2008-2682
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860581);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-2682");
  script_cve_id("CVE-2008-1233", "CVE-2008-1235", "CVE-2008-1236", "CVE-2008-1237", "CVE-2008-1234", "CVE-2008-1238", "CVE-2008-1241");
  script_name( "Fedora Update for epiphany FEDORA-2008-2682");
  desc = "

  Vulnerability Insight:
  epiphany is a simple GNOME web browser based on the Mozilla rendering
  engine.


  Affected Software/OS:
  epiphany on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-March/msg00579.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of epiphany");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"epiphany", rpm:"epiphany~2.20.3~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}