###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for pcmanx-gtk2 FEDORA-2008-11511
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860970);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-11511");
  script_cve_id("CVE-2008-5500", "CVE-2008-5507", "CVE-2008-5506", "CVE-2008-5501", "CVE-2008-5513", "CVE-2008-5502", "CVE-2008-5512", "CVE-2008-5511", "CVE-2008-5505", "CVE-2008-5510", "CVE-2008-5508");
  script_name( "Fedora Update for pcmanx-gtk2 FEDORA-2008-11511");
  desc = "

  Vulnerability Insight:
  An easy-to-use telnet client mainly targets BBS users.
  
  PCMan X is a newly developed GPL'd version of PCMan, a full-featured
  famous BBS client formerly designed for MS Windows only.  It aimed to
  be an easy-to-use yet full-featured telnet client facilitating BBS
  browsing with the ability to process double-byte characters.


  Affected Software/OS:
  pcmanx-gtk2 on Fedora 10

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-December/msg01012.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of pcmanx-gtk2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC10")
{

  if(isrpmvuln(pkg:"pcmanx-gtk2", rpm:"pcmanx-gtk2~0.3.8~4.fc10", rls:"FC10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}