###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for kdegraphics FEDORA-2007-685
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861145);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-685");
  script_cve_id("CVE-2007-3387");
  script_name( "Fedora Update for kdegraphics FEDORA-2007-685");
  desc = "

  Vulnerability Insight:
  Graphics applications for the K Desktop Environment.
  
  Includes:
    kdvi (displays TeX .dvi files)
    kghostview (displays postscript files)
    kcoloredit (palette editor and color chooser)
    kiconedit (icon editor)
    kolourpaint (a simple drawing program)
    ksnapshot (screen capture utility)
    kview (image viewer for GIF, JPEG, TIFF, etc.)
    kooka (scanner application)
    kruler (screen ruler and color measurement tool)
    kpdf (display pdf files)


  Affected Software/OS:
  kdegraphics on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-August/msg00492.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdegraphics");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"kdegraphics", rpm:"kdegraphics~3.5.7~1.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/kdegraphics-debuginfo", rpm:"x86_64/debug/kdegraphics-debuginfo~3.5.7~1.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kdegraphics-devel", rpm:"x86_64/kdegraphics-devel~3.5.7~1.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kdegraphics", rpm:"x86_64/kdegraphics~3.5.7~1.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kdegraphics", rpm:"i386/kdegraphics~3.5.7~1.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kdegraphics-devel", rpm:"i386/kdegraphics-devel~3.5.7~1.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/kdegraphics-debuginfo", rpm:"i386/debug/kdegraphics-debuginfo~3.5.7~1.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}