###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for lha FEDORA-2007-557
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861336);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-557");
  script_cve_id("CVE-2006-4335");
  script_name( "Fedora Update for lha FEDORA-2007-557");
  desc = "

  Vulnerability Insight:
  LHA is an archiving and compression utility for LHarc format archives.
  LHA is mostly used in the DOS world, but can be used under Linux to
  extract DOS files from LHA archives.
  
  Install the lha package if you need to extract DOS files from LHA archives


  Affected Software/OS:
  lha on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-May/msg00072.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of lha");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"lha", rpm:"lha~1.14i~20", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/lha-debuginfo", rpm:"x86_64/debug/lha-debuginfo~1.14i~20", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/lha", rpm:"x86_64/lha~1.14i~20", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/lha-debuginfo", rpm:"i386/debug/lha-debuginfo~1.14i~20", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/lha", rpm:"i386/lha~1.14i~20", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}