###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for file FEDORA-2007-541
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861070);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-541");
  script_cve_id("CVE-2007-2799");
  script_name( "Fedora Update for file FEDORA-2007-541");
  desc = "

  Vulnerability Insight:
  The file command is used to identify a particular file according to the
  type of data contained by the file.  File can identify many different
  file types, including ELF binaries, system libraries, RPM packages, and
  different graphics formats.
  
  You should install the file package, since the file command is such a
  useful utility.


  Affected Software/OS:
  file on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-June/msg00157.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"file", rpm:"file~4.21~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/file", rpm:"x86_64/file~4.21~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/file-debuginfo", rpm:"x86_64/debug/file-debuginfo~4.21~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/file-debuginfo", rpm:"i386/debug/file-debuginfo~4.21~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/file", rpm:"i386/file~4.21~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}