###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for mutt FEDORA-2007-539
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861106);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-539");
  script_cve_id("CVE-2007-1558", "CVE-2007-2683");
  script_name( "Fedora Update for mutt FEDORA-2007-539");
  desc = "

  Vulnerability Insight:
  Mutt is a text-mode mail user agent. Mutt supports color, threading,
  arbitrary key remapping, and a lot of customization.
  
  You should install mutt if you have used it in the past and you prefer
  it, or if you are new to mail programs and have not decided which one
  you are going to use.


  Affected Software/OS:
  mutt on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-May/msg00056.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mutt");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"mutt", rpm:"mutt~1.4.2.3~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/mutt-debuginfo", rpm:"x86_64/debug/mutt-debuginfo~1.4.2.3~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/mutt", rpm:"x86_64/mutt~1.4.2.3~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/mutt-debuginfo", rpm:"i386/debug/mutt-debuginfo~1.4.2.3~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/mutt", rpm:"i386/mutt~1.4.2.3~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}