###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for zabbix FEDORA-2007-4176
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861466);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-4176");
  script_cve_id("");
  script_name( "Fedora Update for zabbix FEDORA-2007-4176");
  desc = "

  Vulnerability Insight:
  ZABBIX is software that monitors numerous parameters of a
  network and the health and integrity of servers. ZABBIX
  uses a flexible notification mechanism that allows users
  to configure e-mail based alerts for virtually any event.
  This allows a fast reaction to server problems. ZABBIX
  offers excellent reporting and data visualisation features
  based on the stored data. This makes ZABBIX ideal for
  capacity planning.
  
  ZABBIX supports both polling and trapping. All ZABBIX
  reports and statistics, as well as configuration
  parameters are accessed through a web-based front end. A
  web-based front end ensures that the status of your network
  and the health of your servers can be assessed from any
  location. Properly configured, ZABBIX can play an important
  role in monitoring IT infrastructure. This is equally true
  for small organisations with a few servers and for large
  companies with a multitude of servers.


  Affected Software/OS:
  zabbix on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00232.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of zabbix");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"zabbix", rpm:"zabbix~1.4.2~4.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zabbix-web", rpm:"zabbix-web~1.4.2~4.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zabbix", rpm:"zabbix~1.4.2~4.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zabbix-agent", rpm:"zabbix-agent~1.4.2~4.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zabbix-debuginfo", rpm:"zabbix-debuginfo~1.4.2~4.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zabbix", rpm:"zabbix~1.4.2~4.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zabbix-web", rpm:"zabbix-web~1.4.2~4.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zabbix-agent", rpm:"zabbix-agent~1.4.2~4.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zabbix-debuginfo", rpm:"zabbix-debuginfo~1.4.2~4.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}