###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ImageMagick FEDORA-2007-414
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861508);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-414");
  script_cve_id("CVE-2007-1797", "CVE-2006-5456", "CVE-2006-3743", "CVE-2006-4144");
  script_name( "Fedora Update for ImageMagick FEDORA-2007-414");
  desc = "

  Vulnerability Insight:
  ImageMagick(TM) is an image display and manipulation tool for the X
  Window System. ImageMagick can read and write JPEG, TIFF, PNM, GIF,
  and Photo CD image formats. It can resize, rotate, sharpen, color
  reduce, or add special effects to an image, and when finished you can
  either save the completed work in the original format or a different
  one. ImageMagick also includes command line programs for creating
  animated or transparent .gifs, creating composite images, creating
  thumbnail images, and more.
  
  ImageMagick is one of your choices if you need a program to manipulate
  and dis play images. If you want to develop your own applications
  which use ImageMagick code or APIs, you need to install
  ImageMagick-devel as well


  Affected Software/OS:
  ImageMagick on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-April/msg00047.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ImageMagick");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"ImageMagick", rpm:"ImageMagick~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ImageMagick-c++-devel", rpm:"x86_64/ImageMagick-c++-devel~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ImageMagick-c++", rpm:"x86_64/ImageMagick-c++~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ImageMagick", rpm:"x86_64/ImageMagick~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/ImageMagick-debuginfo", rpm:"x86_64/debug/ImageMagick-debuginfo~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ImageMagick-perl", rpm:"x86_64/ImageMagick-perl~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ImageMagick-devel", rpm:"x86_64/ImageMagick-devel~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ImageMagick", rpm:"i386/ImageMagick~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ImageMagick-c++-devel", rpm:"i386/ImageMagick-c++-devel~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ImageMagick-perl", rpm:"i386/ImageMagick-perl~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/ImageMagick-debuginfo", rpm:"i386/debug/ImageMagick-debuginfo~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ImageMagick-c++", rpm:"i386/ImageMagick-c++~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ImageMagick-devel", rpm:"i386/ImageMagick-devel~6.2.5.4~4.2.1.fc5.8", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}