###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for perl FEDORA-2007-3218
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861079);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-3218");
  script_cve_id("CVE-2007-5116");
  script_name( "Fedora Update for perl FEDORA-2007-3218");
  desc = "

  Vulnerability Insight:
  Perl is a high-level programming language with roots in C, sed, awk
  and shell scripting.  Perl is good at handling processes and files,
  and is especially good at handling text.  Perl's hallmarks are
  practicality and efficiency.  While it is used to do a lot of
  different things, Perl's most common applications are system
  administration utilities and web programming.  A large proportion of
  the CGI scripts on the web are written in Perl.  You need the perl
  package installed on your system so that your system can handle Perl
  scripts.
  
  Install this package if you want to program in Perl or enable your
  system to handle Perl scripts.


  Affected Software/OS:
  perl on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00307.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of perl");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"perl", rpm:"perl~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-debuginfo", rpm:"perl-debuginfo~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-core", rpm:"perl-core~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-libs", rpm:"perl-libs~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-suidperl", rpm:"perl-suidperl~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Test-Simple", rpm:"perl-Test-Simple~0.62~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl", rpm:"perl~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Test-Harness", rpm:"perl-Test-Harness~2.56~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-ExtUtils-MakeMaker", rpm:"perl-ExtUtils-MakeMaker~6.30~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-CPAN", rpm:"perl-CPAN~1.76_02~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-devel", rpm:"perl-devel~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-ExtUtils-Embed", rpm:"perl-ExtUtils-Embed~1.26~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-debuginfo", rpm:"perl-debuginfo~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-suidperl", rpm:"perl-suidperl~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-libs", rpm:"perl-libs~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-CPAN", rpm:"perl-CPAN~1.76_02~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-core", rpm:"perl-core~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-devel", rpm:"perl-devel~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-ExtUtils-MakeMaker", rpm:"perl-ExtUtils-MakeMaker~6.30~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl", rpm:"perl~5.8.8~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Test-Harness", rpm:"perl-Test-Harness~2.56~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Test-Simple", rpm:"perl-Test-Simple~0.62~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-ExtUtils-Embed", rpm:"perl-ExtUtils-Embed~1.26~31.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}