###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for subversion FEDORA-2007-2635
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861141);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2635");
  script_cve_id("CVE-2007-2448");
  script_name( "Fedora Update for subversion FEDORA-2007-2635");
  desc = "

  Vulnerability Insight:
  Subversion is a concurrent version control system which enables one
  or more users to collaborate in developing and maintaining a
  hierarchy of files and directories while keeping a history of all
  changes.  Subversion only stores the differences between versions,
  instead of every complete file.  Subversion is intended to be a
  compelling replacement for CVS.


  Affected Software/OS:
  subversion on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-October/msg00371.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of subversion");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"subversion", rpm:"subversion~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_dav_svn", rpm:"mod_dav_svn~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion-javahl", rpm:"subversion-javahl~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion-ruby", rpm:"subversion-ruby~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion-devel", rpm:"subversion-devel~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion-debuginfo", rpm:"subversion-debuginfo~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion-perl", rpm:"subversion-perl~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion", rpm:"subversion~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion-javahl", rpm:"subversion-javahl~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion-perl", rpm:"subversion-perl~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion-ruby", rpm:"subversion-ruby~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_dav_svn", rpm:"mod_dav_svn~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion-devel", rpm:"subversion-devel~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion-debuginfo", rpm:"subversion-debuginfo~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subversion", rpm:"subversion~1.4.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}