###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for flac FEDORA-2007-2596
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861408);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2596");
  script_cve_id("CVE-2007-4619");
  script_name( "Fedora Update for flac FEDORA-2007-2596");
  desc = "

  Vulnerability Insight:
  FLAC stands for Free Lossless Audio Codec. Grossly oversimplified, FLAC
  is similar to Ogg Vorbis, but lossless. The FLAC project consists of
  the stream format, reference encoders and decoders in library form,
  flac, a command-line program to encode and decode FLAC files, metaflac,
  a command-line metadata editor for FLAC files and input plugins for
  various music players.


  Affected Software/OS:
  flac on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00035.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of flac");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"flac", rpm:"flac~1.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"flac", rpm:"flac~1.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"flac-debuginfo", rpm:"flac-debuginfo~1.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"flac-devel", rpm:"flac-devel~1.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"flac", rpm:"flac~1.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"flac-devel", rpm:"flac-devel~1.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"flac-debuginfo", rpm:"flac-debuginfo~1.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}