###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for gd FEDORA-2007-2055
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861568);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2055");
  script_cve_id("CVE-2007-3472", "CVE-2007-3473", "CVE-2007-3474", "CVE-2007-3475", "CVE-2007-3476", "CVE-2007-3477", "CVE-2007-3478");
  script_name( "Fedora Update for gd FEDORA-2007-2055");
  desc = "

  Vulnerability Insight:
  The gd graphics library allows your code to quickly draw images
  complete with lines, arcs, text, multiple colors, cut and paste from
  other images, and flood fills, and to write out the result as a PNG or
  JPEG file. This is particularly useful in Web applications, where PNG
  and JPEG are two of the formats accepted for inline images by most
  browsers. Note that gd is not a paint program.


  Affected Software/OS:
  gd on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-September/msg00117.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"gd", rpm:"gd~2.0.35~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gd-debuginfo", rpm:"gd-debuginfo~2.0.35~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gd-devel", rpm:"gd-devel~2.0.35~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gd-progs", rpm:"gd-progs~2.0.35~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gd", rpm:"gd~2.0.35~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gd-progs", rpm:"gd-progs~2.0.35~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gd", rpm:"gd~2.0.35~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gd-debuginfo", rpm:"gd-debuginfo~2.0.35~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gd-devel", rpm:"gd-devel~2.0.35~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}