###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for id3lib FEDORA-2007-1774
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861395);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-1774");
  script_cve_id("CVE-2007-4460");
  script_name( "Fedora Update for id3lib FEDORA-2007-1774");
  desc = "

  Vulnerability Insight:
  This package provides a software library for manipulating ID3v1 and
  ID3v2 tags. It provides a convenient interface for software developers
  to include standards-compliant ID3v1/2 tagging capabilities in their
  applications. Features include identification of valid tags, automatic
  size conversions, (re)synchronisation of tag frames, seamless tag
  (de)compression, and optional padding facilities. Additionally, it can
  tell mp3 header info, like bitrate etc.


  Affected Software/OS:
  id3lib on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-August/msg00358.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of id3lib");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"id3lib", rpm:"id3lib~3.8.3~17.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"id3lib", rpm:"id3lib~3.8.3~17.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"id3lib-devel", rpm:"id3lib-devel~3.8.3~17.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"id3lib-debuginfo", rpm:"id3lib-debuginfo~3.8.3~17.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"id3lib-debuginfo", rpm:"id3lib-debuginfo~3.8.3~17.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"id3lib", rpm:"id3lib~3.8.3~17.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"id3lib-devel", rpm:"id3lib-devel~3.8.3~17.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}