###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for bind FEDORA-2007-164
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861148);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-164");
  script_cve_id("CVE-2006-4095");
  script_name( "Fedora Update for bind FEDORA-2007-164");
  desc = "

  Vulnerability Insight:
  BIND (Berkeley Internet Name Domain) is an implementation of the DNS
  (Domain Name System) protocols. BIND includes a DNS server (named),
  which resolves host names to IP addresses; a resolver library
  (routines for applications to use when interfacing with DNS); and
  tools for verifying that the DNS server is operating properly.


  Affected Software/OS:
  bind on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-January/msg00180.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of bind");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/bind-devel", rpm:"x86_64/bind-devel~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/bind-debuginfo", rpm:"x86_64/debug/bind-debuginfo~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/bind-libs", rpm:"x86_64/bind-libs~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/bind-sdb", rpm:"x86_64/bind-sdb~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/bind-libbind-devel", rpm:"x86_64/bind-libbind-devel~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/bind-chroot", rpm:"x86_64/bind-chroot~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/bind-utils", rpm:"x86_64/bind-utils~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/bind", rpm:"x86_64/bind~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/caching-nameserver", rpm:"x86_64/caching-nameserver~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/bind-devel", rpm:"i386/bind-devel~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/bind-libbind-devel", rpm:"i386/bind-libbind-devel~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/bind-chroot", rpm:"i386/bind-chroot~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/bind-debuginfo", rpm:"i386/debug/bind-debuginfo~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/bind", rpm:"i386/bind~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/bind-utils", rpm:"i386/bind-utils~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/caching-nameserver", rpm:"i386/caching-nameserver~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/bind-sdb", rpm:"i386/bind-sdb~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/bind-libs", rpm:"i386/bind-libs~9.3.4~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}