###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for squirrelmail FEDORA-2007-088
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861140);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-088");
  script_cve_id("CVE-2006-6142", "CVE-2006-4019", "CVE-2006-3174", "CVE-2006-2842");
  script_name( "Fedora Update for squirrelmail FEDORA-2007-088");
  desc = "

  Vulnerability Insight:
  SquirrelMail is a standards-based webmail package written in PHP4. It
  includes built-in pure PHP support for the IMAP and SMTP protocols, and
  all pages render in pure HTML 4.0 (with no Javascript) for maximum
  compatibility across browsers.  It has very few requirements and is very
  easy to configure and install. SquirrelMail has all the functionality
  you would want from an email client, including strong MIME support,
  address books, and folder manipulation.


  Affected Software/OS:
  squirrelmail on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-January/msg00101.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of squirrelmail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"squirrelmail", rpm:"squirrelmail~1.4.8~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ppc/squirrelmail", rpm:"ppc/squirrelmail~1.4.8~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/squirrelmail", rpm:"x86_64/squirrelmail~1.4.8~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/squirrelmail", rpm:"i386/squirrelmail~1.4.8~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}