###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_eureka_email_bof_vuln.nasl 5593 2009-11-05 14:45:29Z nov $
#
# Eureka Email Stack-Based Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801041);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3837");
  script_name("Eureka Email Stack-Based Buffer Overflow Vulnerability");
  desc = "
  Overview: This host is installed with Eureka Email and is prone to stack-based
  buffer overflow vulnerability.

  Vulnerability Insight:
  The flaw is caused due to a boundary error in the processing POP3 responses.
  This can be exploited to cause a stack-based buffer overflow via an overly long
  error response.

  Impact:
  Successful exploitation allows remote attackers to crash an affected client
  or execute arbitrary code by tricking a user into connecting to a malicious
  POP3 server.

  Impact level: Application.

  Affected Software/OS:
  Eureka Email version 2.2q and prior.

  Fix: No solution or patch is available as on 05th November, 2009. Information
  regarding this issue will update once the solution details are available.
  For updates refer, http://www.eureka-email.com/

  References:
  http://xforce.iss.net/xforce/xfdb/53940
  http://secunia.com/advisories/product/27632/
  http://www.vupen.com/english/advisories/2009/3025
  http://www.packetstormsecurity.org/0910-exploits/eurekamc-dos.txt

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Eureka Email");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_eureka_email_detect.nasl");
  script_require_keys("EurekaEmail/Ver");
  exit(0);
}


include("version_func.inc");

eeVer = get_kb_item("EurekaEmail/Ver");
if(eeVer != NULL)
{
  # Eureka Email 2.2q (2.2.0.1)
  if(version_is_less_equal(version:eeVer, test_version:"2.2.0.1")){
    security_hole(0);
  }
}
