###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_etrust_pestpatrol_actvx_ctrl_bof_vuln.nasl 6122 2009-12-16 21:26:16Z dec $
#
# CA eTrust PestPatrol Anti-Spyware 'ppctl.dll' ActiveX Control BOF Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801098);
  script_version("$Revision: 6162 $");
  script_cve_id("CVE-2009-4225");
  script_bugtraq_id(37133);
  script_name("CA eTrust PestPatrol Anti-Spyware 'ppctl.dll' ActiveX Control BOF Vulnerability");
  desc = "
  Overview: This host is installed with CA eTrust PestPatrol Anti-Spyware and
  is prone to Buffer Overflow vulnerability.

  Vulnerability Insight:
  A Stack-based buffer overflow error in ActiveX control in 'ppctl.dll', which
  can be caused by persuading a victim to visit a specially-crafted Web page
  that passes an overly long string argument to the 'Initialize()' method.

  Impact:
  Successful exploitation could allow execution of arbitrary code, and cause the
  victim's browser to crash.

  Impact Level: Application

  Affected Software/OS:
  CA eTrust PestPatrol Anti-Spyware

  Fix:
  No solution or patch is available as on 16th December, 2009. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://www.pestpatrol.com/

  Workaround:
  Set kill bit for the CLSID,
  {5e644c49-f8b0-4e9a-a2ed-5f176bb18ce6}

  References:
  http://xforce.iss.net/xforce/xfdb/54458
  http://www.fortiguard.com/encyclopedia/vulnerability/ca.etrust.pestpatrol.ppctl.dll.activex.access.html
  http://www.metasploit.com/redmine/projects/framework/repository/revisions/7167/entry/modules/exploits/windows/fileformat/etrust_pestscan.rb

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.0
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of ppctl.dll file and CLSID");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2009 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

ppPath = registry_get_sz(key:"SOFTWARE\ComputerAssociates\eTrustPestPatrol",
                         item:"InstallPath");
if(ppPath)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:ppPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:ppPath +
                      "\ppctl.dll");
  ppVer = GetVer(file:file, share:share);

  if(ppVer)
  {
    if(version_is_equal(version:ppVer, test_version:"5.6.7.9"))
    {
      if(is_killbit_set(clsid:"{5e644c49-f8b0-4e9a-a2ed-5f176bb18ce6}") == 0){
        security_hole(0);
      }
    }
  }
}
