###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_eticket_pri_para_mult_sql_inj_vuln.nasl 508 2008-11-21 10:46:27Z nov $
#
# eTicket pri Parameter Multiple SQL Injection Vulnerabilities
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800141);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-5165");
  script_bugtraq_id(29973);
  script_name("eTicket pri Parameter Multiple SQL Injection Vulnerabilities");
  desc = "

  Overview: The host is running eTicket, which is prone to multiple SQL Injection
  vulnerabilities.

  Vulnerability Insight:
  Input passed to the pri parameter of index.php, open.php, open_raw.php, and
  newticket.php is not properly sanitised before being used in SQL queries.

  Impact:
  Successful attack could allow manipulation of the database by injecting
  arbitrary SQL queries.

  Impact Level: Application

  Affected Software/OS:
  eTicket Version 1.5.7 and prior.

  Fix: Update to Version 1.7.0 or later.
  http://www.eticketsupport.com/

  References:
  http://secunia.com/advisories/30877
  http://www.eticketsupport.com/announcements/170_is_in_the_building-t91.0.html
  http://www.digitrustgroup.com/advisories/web-application-security-eticket2.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of eTicket");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach dir (make_list("/eTicket", cgi_dirs()))
{
  sndReq = http_get(item:string(dir + "/license.txt"), port:port);
  rcvRes = http_keepalive_send_recv(port:port,data:sndReq,bodyonly:1);
  if(rcvRes == NULL){
    exit(0);
  }

  if("eTicket" >< rcvRes)
  {
    eTicVer = eregmatch(pattern:"eTicket ([0-9.]+)", string:rcvRes);
    if(eTicVer[1] != NULL)
    {
      # Check for eTicket Version <= 1.5.7
      if(version_is_less_equal(version:eTicVer[1], test_version:"1.5.7")){
        security_hole(0);
      }
    }
    exit(0);
  }
}
