###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_dotproject_priv_escalation_vuln.nasl 1935 06-05-2009 12:05:33Z may $
#
# dotProject Privilege Escalation Vulnerability.
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800565);
  script_version("Revision: 1.0");
  script_cve_id("CVE-2008-6747");
  script_bugtraq_id(29679);
  script_name("dotProject Privilege Escalation Vulnerability");
  desc = "

  Overview: The host is installed with dotProject and is prone to Privilege
  Escalation vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper restrictions on access to certain
  administrative pages.

  Impact:
  Attackers can exploit this issue via specially crafted HTTP request to
  certain administrative pages to gain administrative privileges on the
  affected system.

  Impact Level: Application

  Affected Software/OS:
  dotProject version prior to 2.1.2

  Fix: Upgrade to version 2.1.2
  http://www.dotproject.net

  References:
  http://en.securitylab.ru/nvd/378282.php
  http://xforce.iss.net/xforce/xfdb/43019

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of dotProject");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Privilege escalation");
  script_dependencies("gb_dotproject_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

appPort = get_http_port(default:80);
if(!appPort){
  exit(0);
}

dotVer = get_kb_item("www/" + appPort + "/dotProject");
dotVer = eregmatch(pattern:"^(.+) under (/.*)$", string:dotVer);
if(dotVer[1] == NULL){
  exit(0);
}

if(version_is_less(version:dotVer[1], test_version:"2.1.2")){
  security_warning(appPort);
}
