###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_designworks_professional_detect.nasl 686 2009-03-09 13:45:24Z mar $
#
# DesignWorks Professional Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800367);
  script_version("Revision: 1.0 ");
  script_name("DesignWorks Professional Version Detection");
  desc = "
  Overview: This script detects the installed version of DesignWorks
  Professional and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of DesignWorks Professional");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Capilano")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  if("DesignWorks Professional" ><
     registry_get_sz(key:key + item, item:"DisplayName"))
  {
    exePath = registry_get_sz(key:key + item, item:"UninstallString");
    exePath = eregmatch(pattern:"([A-Za-z0-9:.\]+) (.*)", string:exePath);
    if(exePath[2] == NULL){
      exit(0);
    }

    exePath = exePath[2] - "\uninstal.log" + "\System.dll";
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

    soc = open_sock_tcp(port);
    if(!soc){
      exit(0);
    }

    r = smb_session_request(soc:soc, remote:name);
    if(!r){
      close(soc);
      exit(0);
    }

    prot = smb_neg_prot(soc:soc);
    if(!prot){
      close(soc);
      exit(0);
    }

    r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
                          prot:prot);
    if(!r){
      close(soc);
      exit(0);
    }

    uid = session_extract_uid(reply:r);
    if(!uid){
      close(soc);
      exit(0);
    }

    r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
    tid = tconx_extract_tid(reply:r);
    if(!tid){
      close(soc);
      exit(0);
    }

    fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
    if(!fid){
      close(soc);
      exit(0);
    }

    dwpVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr="prod");
    close(soc);
    if(dwpVer != NULL){
      set_kb_item(name:"DesignWorks/Prof/Ver", value:dwpVer);
    }
    exit(0);
  }
}
