###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_designworks_professional_bof_vuln.nasl 686 2009-03-09 14:34:34Z mar $
#
# DesignWorks Professional '.cct' File BOF Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800368);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6363");
  script_bugtraq_id(32667);
  script_name("DesignWorks Professional '.cct' File BOF Vulnerability");
  desc = "

  Overview: The host is installed with DesignWorks Professional and is prone
  to stack overflow vulnerability.

  Vulnerability Insight:
  Boundary error exists when processing '.cct' files.

  Impact:
  Successful exploitation will let the remote attackers execute arbitrary code
  by tricking a user into opening a specially crafted file and can cause stack
  overflow in the context of the affected application.

  Impact Level: Application

  Affected Software/OS:
  DesignWorks Professional version 5.0.7 and prior.

  Fix: No solution or patch is available as on 18th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.capilano.com/html/dwwp.html

  References:
  http://secunia.com/advisories/33043
  http://www.milw0rm.com/exploits/7362
  http://www.vupen.com/english/advisories/2008/3369

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of DesignWorks Professional");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_designworks_professional_detect.nasl");
  script_require_keys("DesignWorks/Prof/Ver");
  exit(0);
}


include("version_func.inc");

dwpVer = get_kb_item("DesignWorks/Prof/Ver");
if(!dwpVer){
  exit(0);
}

# Check for DesignWorks Professional version 5.0.7 or prior
if(version_is_less_equal(version:dwpVer, test_version:"5.0.7")){
  security_hole(0);
}
