###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_cups_ipp_dos_vuln.nasl 2633 2009-06-03 16:02:24Z june $
#
# CUPS IPP Packets Processing Denial of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800581);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0949");
  script_bugtraq_id(35169);
  script_name("CUPS IPP Packets Processing Denial of Service Vulnerability");
  desc = "

  Overview: This host is running CUPS, and is prone to Denial of Service
  Vulnerability.

  Vulnerability Insight:
  The flaw is cause due to a NULL-pointer dereference that occurs when
  processing two consecutive IPP_TAG_UNSUPPORTED tags in specially
  crafted IPP (Internet Printing Protocol) packets.

  Impact:
  An attacker can exploit will allow application to crash.

  Impact Level: Application

  Affected Software/OS:
  CUPS version prior to 1.3.10

  Fix: Upgrade to version 1.3.10 or latest
  http://www.cups.org/software.php

  References:
  http://www.coresecurity.com/content/AppleCUPS-null-pointer-vulnerability

  CVSS Score:
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:N/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of CUPS");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_cups_detect.nasl");
  script_require_ports("Services/www", 631);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

cupsPort = get_http_port(default:631);
if(!cupsPort){
  exit(0);
}

cupsVer = get_kb_item("www/"+ cupsPort + "/CUPS");
if(!cupsVer){
  exit(0);
}

if(cupsVer != NULL)
{
  # Check for CUPS version < 1.3.10
  if(version_is_less(version:cupsVer, test_version:"1.3.10")){
    security_warning(cupsPort);
  }
}
