###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_cups_guest_acc_dos_vuln.nasl 0517 2008-11-21 17:05:50Z nov $
#
# CUPS Subscription Incorrectly uses Guest Account DoS Vulnerability
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800142);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-5183", "CVE-2008-5184");
  script_bugtraq_id(32419);
  script_name("CUPS Subscription Incorrectly uses Guest Account DoS Vulnerability");
  desc = "

  Overview: This host is running CUPS (Common UNIX Printing System) Service,
  which is prone to Denial of Service Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error in web interface (cgi-bin/admin.c), which
  uses the guest username when a user is not logged on to the web server.
  This leads to CSRF attacks with the add/cancel RSS subscription functions.

  Impact:
  Successful exploitation causes Denial of Service condition.

  Impact Level: Application

  Affected Software/OS:
  CUPS Versions prior to 1.3.8 on Linux.

  Fix:
  Upgrade to CUPS Version 1.3.8 or later.
  http://www.cups.org/software.php

  References:
  http://www.cups.org/str.php?L2774
  http://www.gnucitizen.org/blog/pwning-ubuntu-via-cups/
  http://www.openwall.com/lists/oss-security/2008/11/19/3

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of CUPS service");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 631);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

cupsPort = get_http_port(default:631);
if(!cupsPort){
  cupsPort = 631;
}

sndReq = http_get(item:string(dir, "/"), port:cupsPort);
recRes = http_send_recv(port:cupsPort, data:sndReq);
if(recRes == NULL){
  exit(0);
}

if("<TITLE>Home - CUPS" >< recRes)
{
  cupsVer = eregmatch(pattern:"CUPS ([0-9.]+)", string:recRes);
  if(cupsVer[1] != NULL)
  {
    # Check for CUPS Version < 1.3.8
    if(version_is_less(version:cupsVer[1], test_version:"1.3.8")){
      security_warning(port);
    }
  }
}
