###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_cscope_mult_bof_vuln.nasl 2156 2009-05-11 15:05:27Z may $
#
# Cscope Multiple Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800611);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0148");
  script_name("Cscope Multiple Buffer Overflow vulnerability");
  desc = "

  Overview: This host has installed Cscope and is prone to Multiple Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  Boundary error exists in various functions using insecure sprintf, snprintf
  via long strings in input such as source-code tokens and pathnames.

  Impact:
  Successful exploitation could allow remote attackers to execute arbitrary
  code or cause buffer overflows while parsing specially crafted files or
  directories.

  Impact Level: Application

  Affected Software/OS:
  Cscope version prior to 15.7a

  Fix: Upgrade to Cscope version 15.7a
  http://sourceforge.net/projects/cscope

  References:
  http://www.vupen.com/english/advisories/2009/1238
  https://bugzilla.redhat.com/show_bug.cgi?id=490667
  http://sourceforge.net/project/shownotes.php?release_id=679527

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor:High";

  script_description(desc);
  script_summary("Check for the Version of Cscope");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_cscope_detect.nasl");
  script_require_keys("Cscope/Linux/Ver");
  exit(0);
}


include("version_func.inc");

cscopeVer = get_kb_item("Cscope/Ver");
if(!cscopeVer){
  exit(0);
}

if(version_is_less(version:cscopeVer, test_version:"15.7a")){
  security_hole(0);
}
