###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_buildbot_mult_xss_vuln.nasl 4320 2009-09-10 01:38:45Z sep $
#
# Buildbot Multiple Cross-Site Scripting Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800935);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2967");
  script_bugtraq_id(36100);
  script_name("Buildbot Multiple Cross-Site Scripting Vulnerabilities");
  desc = "

  Overview: This host is installed with Buildbot and is prone to multiple
  Cross Site Scripting vulnerabilities.

  Vulnerability Insight:
  Several scripts in the application do not adequately sanitise user supplied
  data before processing and returning it to the user.

  Impact:
  Successful exploitation will let the attacker to inject arbitrary web script
  or HTML via unspecified vectors and conduct cross-site scripting attacks.

  Impact Level: Application

  Affected Software/OS:
  Buildbot version 0.7.6 through 0.7.11p2 on all platforms.

  Fix: Apply the patches or upgrade to version 0.7.11p3.
  http://buildbot.net/trac#SecurityAlert

  *****
  NOTE: Please ignore this warning if the patch is already applied.
  *****

  References:
  http://secunia.com/advisories/36352
  http://buildbot.net/trac#SecurityAlert
  http://www.vupen.com/english/advisories/2009/2352

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Buildbot");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_buildbot_detect.nasl");
  script_require_keys("Buildbot/Ver");
  exit(0);
}


include("version_func.inc");

buildbotVer = get_kb_item("Buildbot/Ver");

if(buildbotVer != NULL)
{
  if(version_in_range(version:buildbotVer, test_version:"0.7.6",
                                          test_version2:"0.7.11.p2")){
    security_warning(0);
  }
}
